package ru.yandex.webmaster3.storage.searchurl.samples.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.sitestructure.RawSearchUrlStatusEnum;

/**
 * @author avhaliullin
 */
public class RawUrlStatusInfo {
    private final RawSearchUrlStatusEnum status;
    private final String region;
    private final DateTime addTime;
    private final String beautyUrl;
    private final Integer httpCode;
    private final String mainHost;
    private final String mainPath;
    private final String mainRegion;
    private final String redirectTarget;
    private final String relCanonicalTarget;
    private final boolean fake;
    private final boolean indexed;
    private final boolean turbo;
    private final boolean fromSitemap;
    private final boolean searchable;
    private final long turboSourceFlag;
    private final long validFromMetrikaLastAccess;
    private final long validFromIndexNowLastAccess;

    public RawUrlStatusInfo(RawSearchUrlStatusEnum status, String region, DateTime addTime, String beautyUrl,
                            Integer httpCode, String mainHost, String mainPath, String mainRegion, String redirectTarget,
                            String relCanonicalTarget, boolean fake, boolean indexed, boolean turbo, boolean fromSitemap,
                            boolean searchable, long turboSourceFlag,
                            long validFromMetrikaLastAccess, long validFromIndexNowLastAccess) {
        this.status = status;
        this.region = region;
        this.addTime = addTime;
        this.beautyUrl = beautyUrl;
        this.httpCode = httpCode;
        this.mainHost = mainHost;
        this.mainPath = mainPath;
        this.mainRegion = mainRegion;
        this.redirectTarget = redirectTarget;
        this.relCanonicalTarget = relCanonicalTarget;
        this.fake = fake;
        this.indexed = indexed;
        this.turbo = turbo;
        this.fromSitemap = fromSitemap;
        this.searchable = searchable;
        this.turboSourceFlag = turboSourceFlag;
        this.validFromMetrikaLastAccess = validFromMetrikaLastAccess;
        this.validFromIndexNowLastAccess = validFromIndexNowLastAccess;
    }

    public RawSearchUrlStatusEnum getStatus() {
        return status;
    }

    public String getRegion() {
        return region;
    }

    public DateTime getAddTime() {
        return addTime;
    }

    public String getBeautyUrl() {
        return beautyUrl;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public String getMainHost() {
        return mainHost;
    }

    public String getMainPath() {
        return mainPath;
    }

    public String getMainRegion() {
        return mainRegion;
    }

    public String getRedirectTarget() {
        return redirectTarget;
    }

    public String getRelCanonicalTarget() {
        return relCanonicalTarget;
    }

    public boolean isFake() {
        return fake;
    }

    public boolean isIndexed() {
        return indexed;
    }

    public boolean isTurbo() {
        return turbo;
    }

    public boolean isFromSitemap() {
        return fromSitemap;
    }

    public boolean isSearchable() {
        return searchable;
    }

    public long getTurboSourceFlag() {
        return turboSourceFlag;
    }

    public long getValidFromMetrikaLastAccess() {
        return validFromMetrikaLastAccess;
    }

    public long getValidFromIndexNowLastAccess() {
        return validFromIndexNowLastAccess;
    }
}
