package ru.yandex.webmaster3.storage.searchurl.samples.data;

import com.google.common.base.Strings;

/**
 * Created by Oleg Bazdyrev on 2019-06-25.
 */
public enum SearchUrlCanonicalStatus {

    UNDEFINED_CANONICAL,
    CANONICAL,
    NOT_CANONICAL,
    FRESH_CANONICAL,
    ;

    public static SearchUrlCanonicalStatus fromUrlAndCanonical(String url, UrlStatusInfo urlStatusInfo) {
        if (urlStatusInfo != null && urlStatusInfo.isFresh() != null && urlStatusInfo.isFresh()) {
            return FRESH_CANONICAL;
        }
        if (urlStatusInfo == null || Strings.isNullOrEmpty(urlStatusInfo.getRelCanonicalTarget())) {
            return UNDEFINED_CANONICAL;
        }
        return urlStatusInfo.getRelCanonicalTarget().equals(url) ? CANONICAL : NOT_CANONICAL;
    }

}
