package ru.yandex.webmaster3.storage.searchurl.samples.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.storage.searchurl.history.data.SearchUrlHistoryIndicator;

/**
 * @author avhaliullin
 */
public enum SearchUrlEventType implements IntEnum {
    @Description("страница ушла с поиска")
    GONE(0, SearchUrlHistoryIndicator.GONE),
    @Description("страница появилась на поиске")
    NEW(1, SearchUrlHistoryIndicator.NEW),
    ;

    private final int value;
    private final SearchUrlHistoryIndicator indicator;

    SearchUrlEventType(int value, SearchUrlHistoryIndicator indicator) {
        this.value = value;
        this.indicator = indicator;
    }

    public SearchUrlHistoryIndicator getIndicator() {
        return indicator;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<SearchUrlEventType> R = IntEnumResolver.r(SearchUrlEventType.class);
}
