package ru.yandex.webmaster3.storage.serplinks;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class SerpLinkInfo {
    private final boolean blocked;
    private final boolean alphaSort;
    private final List<SerpLinksPage> pages;

    public SerpLinkInfo(boolean blocked, boolean alphaSort, List<SerpLinksPage> pages) {
        this.blocked = blocked;
        this.alphaSort = alphaSort;
        this.pages = pages;
    }

    public boolean isBlocked() {
        return blocked;
    }

    public boolean isAlphaSort() {
        return alphaSort;
    }

    public List<SerpLinksPage> getPages() {
        return pages;
    }

    public static enum ModificationStatusEnum {
        NOT_CHANGED,
        DELETED,
        NEW
    }

    public static enum HideStateEnum {
        NOT_HIDDEN("no"),
        CROPPED("cropped"),
        ISOLATED("isolated");

        private final String value;

        private HideStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        public static HideStateEnum getByValue(String value) {
            if (value == null) {
                return NOT_HIDDEN;
            }

            for (HideStateEnum hideState : values()) {
                if (value.equalsIgnoreCase(hideState.value)) {
                    return hideState;
                }
            }

            return NOT_HIDDEN;
        }
    }

    public static class SerpLinksPage {
        private final String id;
        private final URL url;
        private final boolean blocked;
        private final Float weight;
        private final HideStateEnum hideState;
        private final List<SerpLinksPageName> pageNames = new ArrayList<SerpLinksPageName>();
        private final ModificationStatusEnum modificationStatus;

        public SerpLinksPage(String id, URL url, boolean blocked, Float weight, HideStateEnum hideState, ModificationStatusEnum modificationStatus) {
            this.id = id;
            this.url = url;
            this.blocked = blocked;
            this.weight = weight;
            this.hideState = hideState;
            this.modificationStatus = modificationStatus;
        }

        public String getId() {
            return id;
        }

        public URL getUrl() {
            return url;
        }

        public boolean isBlocked() {
            return blocked;
        }

        public Float getWeight() {
            return weight;
        }

        public HideStateEnum getHideState() {
            return hideState;
        }

        public List<SerpLinksPageName> getPageNames() {
            return pageNames;
        }

        public void addPageName(SerpLinksPageName pageName) {
            pageNames.add(pageName);
        }

        public ModificationStatusEnum getModificationStatus() {
            return modificationStatus;
        }
    }

    public static class SerpLinksPageName {
        private final String name;
        private final Float weight;
        private final ModificationStatusEnum modificationStatus;

        public SerpLinksPageName(String name, Float weight, ModificationStatusEnum modificationStatus) {
            this.name = name;
            this.weight = weight;
            this.modificationStatus = modificationStatus;
        }

        public String getName() {
            return name;
        }

        public Float getWeight() {
            return weight;
        }

        public ModificationStatusEnum getModificationStatus() {
            return modificationStatus;
        }
    }
}
