package ru.yandex.webmaster3.storage.services;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.apache.curator.x.discovery.ServiceType;

@Getter
@AllArgsConstructor
public class AliceDialogsInfo implements ServiceInfo {
    public static final CollectionType TYPE_FACTORY_LIST = TypeFactory
            .defaultInstance()
            .constructCollectionType(ArrayList.class, AliceInfo.class);

    private List<AliceInfo> aliceInfos;

    @Override
    public SiteServiceType getType() {
        return SiteServiceType.ALICE_DIALOGS;
    }

    @Getter
    @NoArgsConstructor
    public static class AliceInfo {
        private String name;
        private String slug;
        private String site;
        private boolean hideInStore;
    }
}
