package ru.yandex.webmaster3.storage.services;

import java.util.List;

import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
public class CompanyInfo implements ServiceInfo {
    private Long id;
    private List<DepartmentInfo> departments;
    private List<Name> names;
    private List<Long> permalink;
    private List<String> urlSocial;
    private List<String> emails;
    private List<String> phones;
    private List<String> rubrics;

    @Override
    public SiteServiceType getType() {
        return SiteServiceType.COMPANY_INFO;
    }

    @Getter
    @NoArgsConstructor
    public static class DepartmentInfo {
        private List<Name> names;
        private Address address;
    }

    @Getter
    @NoArgsConstructor
    static class Name {
        String locale;
        String value;
    }

    @Getter
    @NoArgsConstructor
    static class Address {
        String name;
        Coordinate pos;
        Long geoId;
    }

    @Getter
    @NoArgsConstructor
    static class Coordinate {
        Double lat, lon;
    }
}
