package ru.yandex.webmaster3.storage.services;

import java.util.Map;

import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@NoArgsConstructor
@AllArgsConstructor
public class MobileAppInfo implements ServiceInfo {
    public static final MapType TYPE_FACTORY_MAP = TypeFactory
            .defaultInstance()
            .constructMapType(Map.class, String.class, MobileApp.class);

    private Map<String, MobileApp> mobileApps;

    @Override
    public SiteServiceType getType() {
        return SiteServiceType.MOBILE_APP;
    }

    @Getter
    @NoArgsConstructor
    public static class MobileApp {
        private String name;
        private String storeUrl;
        private Price price;
        private String icon;
        private Rating rating;
        private String id;
    }

    @Getter
    @NoArgsConstructor
    static class Price {
        String currency;
        Double value;
    }

    @Getter
    @NoArgsConstructor
    static class Rating {
        Double value;
        Integer votes;
    }

}
