package ru.yandex.webmaster3.storage.settings.dao;


import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.host.CommonDataState;
import ru.yandex.webmaster3.storage.host.CommonDataType;

/*
 * @author kravchenko99
 * @date 8/21/20
 */
@Repository
public class CommonDataStateYDao extends AbstractCommonDataStateYDao<CommonDataType, CommonDataState> {
    private static final String TABLE_NAME = "common_data_state";


    @Autowired
    public CommonDataStateYDao() {
        super(PREFIX_WEBMASTER3, TABLE_NAME, CommonDataType.R);
    }

    @Override
    public CommonDataState createData(CommonDataType type, String value, DateTime updateDate) {
        return new CommonDataState(type, value, updateDate);
    }

    @Override
    public void update(CommonDataState commonDataState) {
        super.update(commonDataState);
    }
}
