package ru.yandex.webmaster3.storage.settings.data;

import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class AbstractCommonDataState<T extends Enum<T>> {
    private final T type;
    private final String value;
    private final DateTime lastUpdate;

    public AbstractCommonDataState(T type, String value, DateTime lastUpdate) {
        this.type = type;
        this.value = value;
        this.lastUpdate = lastUpdate;
    }

    public T getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public DateTime getLastUpdate() {
        return lastUpdate;
    }
}
