package ru.yandex.webmaster3.storage.settings.history;

import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import ru.yandex.webmaster3.storage.user.UserTakeoutDataProvider;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

import java.util.List;

@Repository
// таблица
public class UserSettingsHistoryYDao extends AbstractYDao implements UserTakeoutDataProvider {
    private static final String TABLE_NAME = "user_settings_history";

    protected UserSettingsHistoryYDao() {
        super(PREFIX_INTERNAL, TABLE_NAME);
    }

    public void insert(SettingsHistoryService.LogSettingInfo info) {
        upsert(
                F.TYPE.value(info.getType()),
                F.USER_ID.value(info.getUserId()),
                F.NEW_STATE.value(info.getNewState()),
                F.HOST_ID.value(info.getHostId()),
                F.UPDATE_DATE.value(info.getUpdateDate())
        ).execute();
    }

    @Override
    public @NotNull List<String> getTakeoutTables() {
        // тут специально ничего не удаляем
        return List.of(
                getTablePath()
        );
    }

    private static final class F {
        static final Field<Long> USER_ID = Fields.longField("user_id");
        static final Field<SettingsHistoryType> TYPE = Fields.stringEnumField("type",
                EnumResolver.er(SettingsHistoryType.class)).makeOptional();
        static final Field<DateTime> UPDATE_DATE = Fields.jodaDateTimeField("update_date");

        static final Field<String> HOST_ID = Fields.stringField("host_id").makeOptional();
        static final Field<String> NEW_STATE = Fields.stringField("new_state").makeOptional();
    }
}
