package ru.yandex.webmaster3.storage.sitemap;

import ru.yandex.webmaster3.core.sitemap.SitemapErrorCode;
import ru.yandex.webmaster3.core.sitemap.raw.RawSitemapInfo;

import java.util.Iterator;

/**
 * User: azakharov
 * Date: 04.03.15
 * Time: 20:48
 */
public class SitemapErrorsCollection {
    public SitemapErrorInfo[] errors;

    public static class SitemapErrorInfo {
        public long line;
        public SitemapErrorCode code;
        public String message;
    }

    public static SitemapErrorsCollection createInstance(RawSitemapInfo rawSitemapInfo) {
        SitemapErrorsCollection sitemapErrors = new SitemapErrorsCollection();
        sitemapErrors.errors = new SitemapErrorsCollection.SitemapErrorInfo[rawSitemapInfo.getErrors().size()];
        Iterator<RawSitemapInfo.SitemapError> it = rawSitemapInfo.getErrors().iterator();
        for (int i = 0; i < rawSitemapInfo.getErrors().size() && it.hasNext(); i++) {
            RawSitemapInfo.SitemapError sitemapError = it.next();
            sitemapErrors.errors[i] = new SitemapErrorsCollection.SitemapErrorInfo();
            sitemapErrors.errors[i].line = sitemapError.getLine();
            sitemapErrors.errors[i].code = SitemapErrorCode.R.fromValueOrNull(sitemapError.getErrorCode());
            sitemapErrors.errors[i].message = sitemapError.getMessage();
        }
        return sitemapErrors;
    }
}
