package ru.yandex.webmaster3.storage.sitemap;

import java.io.IOException;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * User: azakharov
 * Date: 04.03.15
 * Time: 20:47
 */
public class SitemapErrorsJson {
    private static final Logger log = LoggerFactory.getLogger(SitemapErrorsJson.class);

    private static final ObjectMapper OM = new ObjectMapper()
            .setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String toJson(@Nullable SitemapErrorsCollection sitemapErrors) throws JsonProcessingException {
        if (sitemapErrors == null) {
            return null;
        }
        String json = OM.writeValueAsString(sitemapErrors);
        log.trace(json);
        return json;
    }

    public static SitemapErrorsCollection fromJson(@Nullable String json) throws IOException {
        if (json == null) {
            return null;
        }
        return OM.readValue(json, SitemapErrorsCollection.class);
    }
}
