package ru.yandex.webmaster3.storage.sitemap;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
* User: azakharov
* Date: 04.09.14
* Time: 13:14
*/
public enum SitemapTypeEnum implements IntEnum {
    ST_UNKNOWN(0),
    ST_TEXT(1),
    ST_XML_SITEMAP(2),
    ST_XML_SITEMAPINDEX(3),
    ST_XML_RSS(4),
    ST_MALFORMED_SITEMAP(5);

    private final int value;

    SitemapTypeEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    public static final IntEnumResolver<SitemapTypeEnum> R = IntEnumResolver.r(SitemapTypeEnum.class);
}
