package ru.yandex.webmaster3.storage.sitemap.dao;

import java.util.function.BiConsumer;
import java.util.function.Consumer;

import com.datastax.driver.core.ConsistencyLevel;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author akhazhoyan 02/2018
 */
@Repository
public class ForceSitemapExportQueueYDao extends AbstractYDao {

    private static final DataMapper<Pair<WebmasterHostId, DateTime>> PAIR_MAPPER = DataMapper.create(F.HOST_ID, F.ENQUEUED, Pair::of);

    public ForceSitemapExportQueueYDao() {
        super(PREFIX_SITEMAP, "sitemap_force_export_queue");
    }

    public void forEach(Consumer<Pair<WebmasterHostId, DateTime>> consumer) {
        streamReader(PAIR_MAPPER, consumer);
    }

    public void addRecord(WebmasterHostId hostId, DateTime date) {
        upsert(F.HOST_ID.value(hostId),
                F.ENQUEUED.value(date)
        ).execute();
    }

    private interface F {
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<DateTime> ENQUEUED = Fields.jodaDateTimeField("enqueued");
    }
}
