package ru.yandex.webmaster3.storage.sitemap.service.model;

import ru.yandex.webmaster3.core.http.FileParameterTransfer;
import ru.yandex.webmaster3.storage.async.model.IRequestData;

/**
 * @author: ishalaru
 * DATE: 14.05.2019
 */
public class AnalyzeSitemapInputData implements IRequestData {
    private final String sitemapText;
    private final String sitemapUrl;
    private final FileParameterTransfer sitemapFile;

    public AnalyzeSitemapInputData(String sitemapText, String sitemapUrl, FileParameterTransfer sitemapFile) {
        this.sitemapText = sitemapText;
        this.sitemapUrl = sitemapUrl;
        this.sitemapFile = sitemapFile;
    }

    public String getSitemapText() {
        return sitemapText;
    }

    public String getSitemapUrl() {
        return sitemapUrl;
    }

    public FileParameterTransfer getSitemapFile() {
        return sitemapFile;
    }
}
