package ru.yandex.webmaster3.storage.sitemap.service.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.storage.async.model.IResponseData;
import ru.yandex.webmaster3.storage.util.SitemapAnalysisResult;

/**
 * @author: ishalaru
 * DATE: 14.05.2019
 */
public class SitemapAnalysisExtendedResult implements IResponseData {
    private final SitemapAnalysisResult sitemapAnalysisResult;
    private final long sitemapFileSize;
    private final String sitemapFileName;


    public SitemapAnalysisExtendedResult(@JsonProperty("sitemapAnalysisResult") SitemapAnalysisResult sitemapAnalysisResult,
                                         @JsonProperty("sitemapFileSize") long sitemapFileSize,
                                         @JsonProperty("sitemapFileName") String sitemapFileName) {
        this.sitemapAnalysisResult = sitemapAnalysisResult;
        this.sitemapFileSize = sitemapFileSize;
        this.sitemapFileName = sitemapFileName;
    }

    public SitemapAnalysisResult getSitemapAnalysisResult() {
        return sitemapAnalysisResult;
    }

    public long getSitemapFileSize() {
        return sitemapFileSize;
    }

    public String getSitemapFileName() {
        return sitemapFileName;
    }
}
