package ru.yandex.webmaster3.storage.sitestructure;

import org.joda.time.Instant;

/**
 * @author avhaliullin
 */
public class StructuresImportInfo {
    private final Instant baseCollectionDate;
    private final Instant structuresTableDate;
    private final StructuresBaseStatus baseStatus;

    public StructuresImportInfo(Instant baseCollectionDate, Instant structuresTableDate, StructuresBaseStatus baseStatus) {
        this.baseCollectionDate = baseCollectionDate;
        this.structuresTableDate = structuresTableDate;
        this.baseStatus = baseStatus;
    }

    public Instant getBaseCollectionDate() {
        return baseCollectionDate;
    }

    public Instant getStructuresTableDate() {
        return structuresTableDate;
    }

    public StructuresBaseStatus getBaseStatus() {
        return baseStatus;
    }
}
