package ru.yandex.webmaster3.storage.spam;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ChainedSpamHostFilter implements ISpamHostFilter {
    private List<ISpamHostFilter> filters;

    @Override
    public boolean checkHost(WebmasterHostId hostId) {
        for (ISpamHostFilter filter : filters) {
            if (filter.checkHost(hostId)) {
                return true;
            }
        }
        return false;
    }

    @Required
    public void setFilters(List<ISpamHostFilter> filters) {
        this.filters = filters;
    }
}
