package ru.yandex.webmaster3.storage.spam;

import java.util.HashSet;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * @author avhaliullin
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class DeepSpamHostFilter implements ISpamHostFilter {
    private static final Logger log = LoggerFactory.getLogger(DeepSpamHostFilter.class);

    private final SpamHostsYDao spamHostsYDao;

    private volatile HashSet<WebmasterHostId> spamHosts = new HashSet<>();

    @Override
    public boolean checkHost(WebmasterHostId hostId) {
        return spamHosts.contains(hostId);
    }

    @Scheduled(fixedDelay = 1000 * 60 * 5, initialDelay = 0)
    public void tryGetAllHosts() {
        try {
            HashSet<WebmasterHostId> hostIds = new HashSet<>();
            spamHostsYDao.getAllHosts(hostIds::add);
            spamHosts = hostIds;
        } catch (WebmasterYdbException e) {
            log.error("Failed to load spam hosts", e);
        }
    }
}
