package ru.yandex.webmaster3.storage.spam;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

import javax.annotation.PostConstruct;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * @author avhaliullin
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class FastSpamHostFilter implements ISpamHostFilter {
    private static final Logger log = LoggerFactory.getLogger(FastSpamHostFilter.class);

    private final SeedSpamHostPatternsYDao seedSpamHostPatternsYDao;
    private volatile Predicate<WebmasterHostId> isBannedPredicate;

    @Override
    public boolean checkHost(WebmasterHostId hostId) {
        return isBannedPredicate.test(hostId);
    }

    @PostConstruct
    @Scheduled(fixedDelay = 1000 * 60 * 5, initialDelay = 0)
    public void tryUpdatePatterns() {
        List<String> newSuffixes = new ArrayList<>();
        try {
            seedSpamHostPatternsYDao.getAllRules(pattern -> newSuffixes.add(pattern.getRight()));
            isBannedPredicate = SpamFilterUtil.makeIsBannedPredicateForSuffixes(newSuffixes);
        } catch (WebmasterYdbException e) {
            log.error("Failed to load spam host patterns", e);
        }
    }
}
