package ru.yandex.webmaster3.storage.spam;

import java.util.UUID;
import java.util.function.Consumer;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository
public class SeedSpamHostPatternsYDao extends AbstractYDao {
    private static final String TABLE_NAME = "seed_spam_host_patterns";

    public SeedSpamHostPatternsYDao() {
        super(PREFIX_INTERNAL, TABLE_NAME);
    }

    public void addRule(UUID ruleId, String rule) {
        upsert(F.RULE_ID.value(ruleId), F.HOST_NAME_SUFFIX.value(rule))
                .execute();
    }

    public void getAllRules(Consumer<Pair<UUID, String>> consumer) {
        streamReader(DataMapper.create(F.RULE_ID, F.HOST_NAME_SUFFIX, Pair::of), consumer);
    }

    private static class F {
        static final Field<UUID> RULE_ID = Fields.uuidField("rule_id");
        static final Field<String> HOST_NAME_SUFFIX = Fields.stringField("host_name_suffix");
    }
}
