package ru.yandex.webmaster3.storage.spam;

import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository
public class SpamHostIPsYDao extends AbstractYDao {
    private static final String TABLE_NAME = "spam_host_ips";

    public SpamHostIPsYDao() {
        super(PREFIX_INTERNAL, TABLE_NAME);
    }

    public Set<String> listIPs() {
        Set<String> res = new TreeSet<>();
        getAllRecords(cons -> res.add(cons.getValue()));
        return res;
    }

    public void getAllRecords(Consumer<Pair<UUID, String>> consumer) {
        streamReader(DataMapper.create(F.RULE_ID, F.IP_ADDRESS, Pair::of), consumer);
    }

    public void insert(UUID ruleId, String ipAddress) {
        upsert(F.RULE_ID.value(ruleId), F.IP_ADDRESS.value(ipAddress)).execute();
    }

    private static class F {
        static final Field<UUID> RULE_ID = Fields.uuidField("rule_id");
        static final Field<String> IP_ADDRESS = Fields.stringField("ip_address");
    }
}
