package ru.yandex.webmaster3.storage.sprav;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.List;

/**
 * Created by ifilippov5 on 18.03.18.
 */
public class CompanyProfileInfo {
    private final WebmasterHostId hostId;
    private final long tycoonId;
    private final long permalink;
    private final double percentage;
    private final FilledPercentageDetail percentageDetail;
    private final List<String> filled;
    private final List<String> toFill;
    private final String url;
    private final String name;
    private final String address;
    private final Double popularity;

    @JsonCreator
    public CompanyProfileInfo(WebmasterHostId hostId, long tycoonId, long permalink, double percentage,
                              FilledPercentageDetail percentageDetail, List<String> filled, List<String> toFill,
                              String url, String name, String address, Double popularity) {
        this.hostId = hostId;
        this.tycoonId = tycoonId;
        this.permalink = permalink;
        this.percentage = percentage;
        this.percentageDetail = percentageDetail;
        this.filled = filled;
        this.toFill = toFill;
        this.url = url;
        this.name = name;
        this.address = address;
        this.popularity = popularity;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public long getTycoonId() {
        return tycoonId;
    }

    public long getPermalink() {
        return permalink;
    }

    public double getPercentage() {
        return percentage;
    }

    public FilledPercentageDetail getPercentageDetail() {
        return percentageDetail;
    }

    public List<String> getFilled() {
        return filled;
    }

    public List<String> getToFill() {
        return toFill;
    }

    public String getUrl() {
        return url;
    }

    public String getName() {
        return name;
    }

    public String getAddress() {
        return address;
    }

    public Double getPopularity() {
        return popularity;
    }
}
