package ru.yandex.webmaster3.storage.takeout;

import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;
import ru.yandex.webmaster3.storage.util.yt.YtPath;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @author leonidrom
 *
 * Проверять таблицы во всех каталогах при каждом запросе на удаление
 * пользовательских данных - это дорого. Поэтому мы сохраняем здесь
 * каталоги, в которых есть таблицы с пользовательскими данными,
 * и при поступлении запроса на удаление ищем таблицы только среди них.
 */
@Repository
public class YtUserDataDirsYDao extends AbstractYDao {
    public YtUserDataDirsYDao() {
        super(PREFIX_INTERNAL, "yt_user_data_dirs");
    }

    public void addBatch(List<YtPath> bath, DateTime updateTime) {
        batchUpdate(getValueDataMapper(updateTime), bath).execute();
    }

    public void clearOldRecords(DateTime ts) {
        delete().where(F.LAST_UPDATE.lt(ts)).execute();
    }

    public List<YtPath> getAll() {
        var l = select(PATH_MAPPER).queryForList();
        return l.stream().distinct().toList();
    }

    private static DataMapper<YtPath> PATH_MAPPER = DataMapper.create(F.PATH, p -> p);

    private static ValueDataMapper<YtPath> getValueDataMapper(DateTime updateTime) {
        return ValueDataMapper.create2(
                Pair.of(F.PATH, path -> path),
                Pair.of(F.CLUSTER, YtPath::getCluster),
                Pair.of(F.LAST_UPDATE, path -> updateTime)
        );
    }

    private static final class F {
        static final Field<YtPath> PATH = Fields.ytPathField("path");
        static final Field<String> CLUSTER = Fields.stringField("cluster");
        static final Field<DateTime> LAST_UPDATE = Fields.jodaDateTimeField("last_update");
    }
}
