package ru.yandex.webmaster3.storage.task;

import java.util.List;
import java.util.UUID;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.Select;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * kravchenko99
 * 20.11.2021
 **/
@Repository
public class TaskStateLogYDao extends AbstractYDao {
    private static final Duration TTL = Duration.standardDays(2);

    public TaskStateLogYDao() {
        super(PREFIX_INTERNAL, "task_state_log");
    }

    public void insert(UUID batchId, String taskId) {
        upsert(F.BATCH_ID.value(batchId),
                F.TASK_ID.value(taskId),
                F.TTL_DATE.value(DateTime.now())
        ).execute();
    }

    public List<String> list(UUID batchId) {
        DateTime ttlThreshold = DateTime.now().minus(TTL);

        Select<String> st = select(F.TASK_ID)
                .where(F.BATCH_ID.eq(batchId))
                .and(F.TTL_DATE.gte(ttlThreshold))
                .order(F.BATCH_ID.asc())
                .order(F.TASK_ID.asc());

        return st.queryForList(list -> {
                    var lastTaskId = list.get(list.size() - 1);
                    return st.cont(F.TASK_ID.gte(lastTaskId)).getStatement();
                }
        );
    }
    public interface F {
        Field<UUID> BATCH_ID = Fields.uuidField("batch_id");
        Field<String> TASK_ID = Fields.stringField("task_id");
        Field<DateTime> TTL_DATE = Fields.jodaDateTimeField("ttl_date");
    }

}
