package ru.yandex.webmaster3.storage.toloka.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Builder;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 09/06/2020.
 */
@Value
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class TolokaAggregatedSolution {

    public static final TypeReference<List<TolokaAggregatedSolution>> TYPE_REFERENCE =
            new TypeReference<List<TolokaAggregatedSolution>>() {
            };

    @JsonProperty("pool_id")
    String poolId;
    @JsonProperty("task_id")
    String taskId;
    @JsonProperty("confidence")
    Double confidence;
    @JsonProperty("aggregated_solution")
    Solution aggregatedSolution;

    @Value
    @JsonIgnoreProperties(ignoreUnknown = true)
    private static final class Solution {
        @JsonProperty("output_values")
        ObjectNode outputValues;
    }
}
