package ru.yandex.webmaster3.storage.toloka.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 09/06/2020.
 */
@Value
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class TolokaOperation {

    private static final String FAIL = "FAIL";
    private static final String SUCCESS = "SUCCESS";

    @JsonProperty("id")
    String id;
    @JsonProperty("type")
    String type;
    @JsonProperty("status")
    String status;

    public boolean isFinished() {
        return FAIL.equals(status) || SUCCESS.equals(status);
    }

    public boolean isSuccess() {
        return SUCCESS.equals(status);
    }

}
