package ru.yandex.webmaster3.storage.toloka.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Builder;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 28/04/2020.
 */
@Value
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class TolokaTask {

    public static final TypeReference<List<TolokaTask>> TYPE_REFERENCE =
            new TypeReference<List<TolokaTask>>() {
            };

    @JsonProperty("id")
    String id;
    @JsonProperty("origin_task_id")
    String originTaskId;
    @JsonProperty("pool_id")
    String poolId;
    @JsonProperty("input_values")
    ObjectNode inputValues;
    @JsonProperty("known_solutions")
    List<TolokaTaskKnownSolution> knownSolutions;
    @JsonProperty("message_on_unknown_solution")
    String messageOnUnknownSolution;
    @JsonProperty("overlap")
    Integer overlap;
    @JsonProperty("infinite_overlap")
    boolean infiniteOverlap;

    // aka honeypot
    @Value
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class TolokaTaskKnownSolution {

        @JsonProperty("correctness_weight")
        double correctnessWeight;
        @JsonProperty("output_values")
        ObjectNode outputValues;

    }
}
