package ru.yandex.webmaster3.storage.turbo.dao;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by ifilippov5 on 28.05.18.
 */
@Repository
public class TurboDomainsWithAcceptedOfferYDao extends AbstractYDao {

    public static final String TABLE_NAME = "turbo_domains_with_accepted_offer";

    public TurboDomainsWithAcceptedOfferYDao() {
        super(PREFIX_TURBO, TABLE_NAME);
    }

    public void add(WebmasterHostId hostId) {
        add(WwwUtil.cutWWWAndM(hostId.getPunycodeHostname()));
    }

    public void add(String domain) {
        upsert(F.DOMAIN.value(domain)).execute();
    }

    public void delete(WebmasterHostId hostId) {
        String domain = WwwUtil.cutWWWAndM(hostId.getPunycodeHostname());
        delete().where(F.DOMAIN.eq(domain)).execute();
    }

    public boolean contains(WebmasterHostId hostId) {
        String domain = WwwUtil.cutWWWAndM(hostId.getPunycodeHostname());
        return contains(domain);
    }

    public boolean contains(String domain) {
        return select(F.DOMAIN).where(F.DOMAIN.eq(domain)).queryOne() != null;
    }

    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
    }
}
