package ru.yandex.webmaster3.storage.turbo.dao;

import ru.yandex.webmaster3.core.turbo.model.error.TurboErrorType;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.storage.download.DownloadStatus;

import java.util.UUID;

/**
 * Created by Oleg Bazdyrev on 08/10/2018.
 */
public class TurboDownloadTask {

    private final UUID taskId;
    private final TurboFeedType feedType;
    private final DownloadStatus status;
    private final TurboErrorType error;
    private final String content;

    public TurboDownloadTask(UUID taskId, TurboFeedType feedType, DownloadStatus status, TurboErrorType error, String content) {
        this.taskId = taskId;
        this.feedType = feedType;
        this.status = status;
        this.error = error;
        this.content = content;
    }

    public UUID getTaskId() {
        return taskId;
    }

    public TurboFeedType getFeedType() {
        return feedType;
    }

    public DownloadStatus getStatus() {
        return status;
    }

    public TurboErrorType getError() {
        return error;
    }

    public String getContent() {
        return content;
    }
}
