package ru.yandex.webmaster3.storage.turbo.dao;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * @author kravchenko99
 * @date 3/2/21
 * Временная таблица которую нужно удалить после выключение всех внешних корзин
 */

@Repository
public class TurboInvalidCartDomainsYDao extends AbstractYDao {
    private static final String TABLE_NAME = "turbo_invalid_cart_domains";

    public TurboInvalidCartDomainsYDao() {
        super(PREFIX_TURBO, TABLE_NAME);
    }

    public boolean isInvalidCart(String domain) {
        final String value = select(F.DOMAIN)
                .where(F.DOMAIN.eq(domain))
                .queryOne();
        return value != null;
    }

    public void delete(String domain) {
        delete().where(F.DOMAIN.eq(domain))
                .execute();
    }


    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
    }
}
