package ru.yandex.webmaster3.storage.turbo.dao.api;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import com.google.common.base.Suppliers;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.W3Collectors;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author avhaliullin
 */
@Repository
public class TurboApiCustomSettingsYDao extends AbstractYDao {
    private static final String TABLE_NAME = "turbo_api_custom_settings";

    private final Supplier<Map<WebmasterHostId, TurboApiSettings>> cache = Suppliers.memoizeWithExpiration(
        this::getAllSettings, 1L, TimeUnit.MINUTES
    );

    public TurboApiCustomSettingsYDao() {
        super(PREFIX_TURBO, TABLE_NAME);
    }

    public Map<WebmasterHostId, TurboApiSettings> getAllSettings() {
        return select(PAIR_MAPPER).queryForList().stream().collect(W3Collectors.toHashMap());
    }

    public TurboApiSettings getSettings(WebmasterHostId hostId) {
        return select(MAPPER).where(F.HOST_ID.eq(hostId)).queryOne();
    }

    public TurboApiSettings getSettingsCached(WebmasterHostId hostId) {
        return cache.get().get(hostId);
    }

    private static final DataMapper<TurboApiSettings> MAPPER = DataMapper.create(
            F.TASKS_IN_PROGRESS_LIMIT, F.TASKS_PER_SECOND_LIMIT, TurboApiSettings::new
    );

    private static final DataMapper<Pair<WebmasterHostId, TurboApiSettings>> PAIR_MAPPER = DataMapper.create(
            F.HOST_ID, MAPPER, Pair::of
    );

    private interface F {
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<Integer> TASKS_IN_PROGRESS_LIMIT = Fields.intField("tasks_in_progress_limit");
        Field<Integer> TASKS_PER_SECOND_LIMIT = Fields.intField("tasks_per_second_limit");
    }
}
