package ru.yandex.webmaster3.storage.turbo.dao.autodelete;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Value;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.checklist.data.TurboHostBanSample;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 19/02/2021.
 */
@Repository
public class TurboAutoDeletedPagesSamplesYDao extends AbstractYDao {

    public TurboAutoDeletedPagesSamplesYDao() {
        super(PREFIX_TURBO, "turbo_auto_deleted_pages_samples");
    }

    public void clearOldRecords(DateTime ts) {
        delete().where(F.TABLE_TS.lt(ts)).execute();
    }

    public List<TurboHostBanSample> getSamples(String domain) {
        List<TurboErrorSample> result = select(F.ERRORS).where(F.DOMAIN.eq(domain)).queryOne();
        if (result == null) {
            return Collections.emptyList();
        }
        return result.stream().map(TurboErrorSample::getSamples).flatMap(Collection::stream).map(TurboUrlsSample::toTurboHostBanSample)
                .collect(Collectors.toList());
    }

    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<Integer> SEVERITY = Fields.intField("severity");
        Field<DateTime> TS = Fields.jodaDateTimeField("ts");
        Field<DateTime> TABLE_TS = Fields.jodaDateTimeField("table_ts");
        Field<DateTime> LAST_CHECK_TS = Fields.jodaDateTimeField("last_check_ts");
        Field<DateTime> DEADLINE_TS = Fields.jodaDateTimeField("deadline_ts");
        Field<List<TurboErrorSample>> ERRORS = Fields.jsonField2("errors", TurboErrorSample.LIST_REFERENCE);
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class TurboErrorSample {
        public static final TypeReference<List<TurboErrorSample>> LIST_REFERENCE = new TypeReference<>() {
        };

        String code;
        List<TurboUrlsSample> samples;
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class TurboUrlsSample {
        @JsonProperty("frozen_turbo_url")
        String frozenUrl;
        @JsonProperty("prod_turbo_url")
        String prodUrl;
        @JsonProperty("original_url")
        String originalUrl;
        @JsonProperty("reasons")
        List<String> reasons;
        @JsonProperty("weight")
        int weight;

        public TurboHostBanSample toTurboHostBanSample() {
            return new TurboHostBanSample(frozenUrl, prodUrl, originalUrl, reasons, weight);
        }
    }
}
