package ru.yandex.webmaster3.storage.turbo.dao.automorda;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Oleg Bazdyrev on 2019-06-03.
 */
public enum TurboAutoMordaStatus implements IntEnum {
    OK(0, "Ok"),
    NOT_ENOUGH_PAGES(1, "NotEnoughPages"),
    NO_PUB_DATE(2, "NoPubDate"),
    ;

    private static Map<String, TurboAutoMordaStatus> VALUES_BY_TURBO_NAME;
    static {
        Map<String, TurboAutoMordaStatus> map = new HashMap<>();
        for (TurboAutoMordaStatus status : values()) {
            map.put(status.getTurboName(), status);
        }
        VALUES_BY_TURBO_NAME = Collections.unmodifiableMap(map);
    }

    private final int value;
    private final String turboName;

    TurboAutoMordaStatus(int value, String turboName) {
        this.value = value;
        this.turboName = turboName;
    }

    @Override
    public int value() {
        return value;
    }

    public String getTurboName() {
        return turboName;
    }

    public static TurboAutoMordaStatus fromTurboName(String turboName) {
        return VALUES_BY_TURBO_NAME.getOrDefault(turboName, NOT_ENOUGH_PAGES);
    }

    public static final IntEnumResolver<TurboAutoMordaStatus> R = IntEnumResolver.r(TurboAutoMordaStatus.class);

}
