package ru.yandex.webmaster3.storage.turbo.dao.autoparser;

import java.util.List;

import com.google.common.collect.Iterables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 2019-08-21.
 */
@Repository
public class TurboRivalsScreenshotsYDao extends AbstractYDao {

    private static final String TABLE_NAME = "turbo_rivals_screenshots";
    private static final DataMapper<PageWithScreenshots> MAPPER = DataMapper.create(F.URL, F.SCREENSHOT, F.TURBO_URL,
            F.TURBO_SCREENSHOT, F.IS_COMMERCIAL, PageWithScreenshots::new);

    @Autowired
    public TurboRivalsScreenshotsYDao() {
        super(PREFIX_TURBO, TABLE_NAME);
    }

    public void insert(PageWithScreenshots pws) {
        execute(
                upsert(
                        F.URL.value(pws.getUrl()),
                        F.SCREENSHOT.value(pws.getScreenshot()),
                        F.TURBO_URL.value(pws.getTurboUrl()),
                        F.TURBO_SCREENSHOT.value(pws.getTurboScreenshot()),
                        F.IS_COMMERCIAL.value(pws.isCommercial())
                )
        );
    }

    public List<PageWithScreenshots> listAll() {
        return queryForList(select(MAPPER).order(F.URL.asc()), MAPPER,
                (l) -> select(MAPPER).where(F.URL.gt(Iterables.getLast(l).getUrl())).order(F.URL.asc())
        );
    }

    private interface F {
        Field<String> URL = Fields.stringField("url");
        Field<String> SCREENSHOT = Fields.stringField("screenshot");
        Field<String> TURBO_URL = Fields.stringField("turbo_url");
        Field<String> TURBO_SCREENSHOT = Fields.stringField("turbo_screenshot");
        Field<Boolean> IS_COMMERCIAL = Fields.boolField("is_commercial");
    }

    @lombok.Value
    public static final class PageWithScreenshots {
        String url;
        String screenshot;
        String turboUrl;
        String turboScreenshot;
        boolean isCommercial;
    }
}
