package ru.yandex.webmaster3.storage.turbo.dao.commerce;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Iterables;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.turbo.model.commerce.TurboPlusSettings;
import ru.yandex.webmaster3.core.util.W3Collectors;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 23/04/2020.
 */
@Repository("turboPlusSettingsYDao")
public class TurboPlusSettingsYDao extends AbstractYDao {

    private static final DataMapper<TurboPlusSettings> MAPPER = DataMapper.create(F.SAFE_SHOPPING, TurboPlusSettings::new);
    private static final DataMapper<Pair<String, TurboPlusSettings>> PAIR_MAPPER = DataMapper.create(F.DOMAIN, MAPPER, Pair::of);

    protected TurboPlusSettingsYDao() {
        super(PREFIX_TURBO, "turbo_plus_settings");
    }

    public void updateSettings(String domain, TurboPlusSettings settings) {
        execute(
                upsert(
                        F.DOMAIN.value(domain),
                        F.SAFE_SHOPPING.value(settings.isSafeShopping())
                )
        );
    }

    public TurboPlusSettings getSettings(String domain) {
        return queryOne(select(MAPPER).where(F.DOMAIN.eq(domain)).limit(1), MAPPER);
    }

    public Map<String, TurboPlusSettings> getSettings(Collection<String> domains) {
        final List<Pair<String, TurboPlusSettings>> pairs = queryForList(select(PAIR_MAPPER).where(F.DOMAIN.in(domains)).order(F.DOMAIN.asc()), PAIR_MAPPER, (list) ->
                select(PAIR_MAPPER).where(F.DOMAIN.in(domains)).and(F.DOMAIN.gt(Iterables.getLast(list).getLeft())).order(F.DOMAIN.asc())
        );
        return pairs.stream().collect(W3Collectors.toHashMap());
    }

    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<Boolean> SAFE_SHOPPING = Fields.boolField("safe_shopping");
    }
}
