package ru.yandex.webmaster3.storage.turbo.dao.landing;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.turbo.model.landing.TurboLandingPreview;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 12/11/2018.
 */
@Repository
public class TurboLandingPreviewsYDao extends AbstractYDao {

    public TurboLandingPreviewsYDao() {
        super(PREFIX_TURBO, "turbo_landing_previews");
    }

    public List<TurboLandingPreview> listAll() {
        // там не больше 10 записей, никакой пагинации
        return queryForList(select(MAPPER), MAPPER).stream().sorted().collect(Collectors.toList());
    }

    private static final DataMapper<TurboLandingPreview> MAPPER = DataMapper.create(
            F.ORDER_ID, F.LABEL, F.PREVIEW_URL, TurboLandingPreview::new);

    private interface F {
        Field<Integer> ORDER_ID = Fields.intField("order_id"); //для сортировки
        Field<String> LABEL = Fields.stringField("label");
        Field<String> PREVIEW_URL = Fields.stringField("preview_url");
    }
}
