package ru.yandex.webmaster3.storage.turbo.dao.scc.model;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Getter;
import lombok.Value;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * ishalaru
 * 17.09.2020
 **/
@Value
@JsonIgnoreProperties(ignoreUnknown = true)
public class TurboSccPremoderationStatus {
    public final static TypeReference<TurboSccPremoderationStatus> TYPE_REFERENCE = new TypeReference<>() {
    };

    private static final TurboSccPremoderationStatus EMPTY = new TurboSccPremoderationStatus();
    // время последней проверки в миллисикундах todoвозможно стоит созранять сразу в DateTime
    @Nullable
    @JsonProperty("modification_timestamp")
    DateTime modificationTimestamp;
    @JsonProperty("status")
    ModerationStatus status;
    @JsonProperty("items")
    List<TurboSccPremoderationStatus.PremoderationItem> items;
    @JsonProperty("categories")
    TurboSccPremoderationStatus.PremoderationCategories categories;


    public static TurboSccPremoderationStatus empty() {
        return EMPTY;
    }

    public TurboSccPremoderationStatus() {
        this(null, null, null, null);
    }

    @JsonCreator
    public TurboSccPremoderationStatus(@Nullable DateTime modificationTimestamp,
                                       ModerationStatus status,
                                       List<PremoderationItem> items,
                                       PremoderationCategories categories) {
        this.modificationTimestamp = modificationTimestamp;
        this.status = ObjectUtils.firstNonNull(status, ModerationStatus.UNKNOWN);
        this.items = ObjectUtils.firstNonNull(items, Collections.emptyList());
        this.categories = ObjectUtils.firstNonNull(categories, PremoderationCategories.empty());
    }

    @Value
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class PremoderationItem {
        @JsonProperty("problems")
        List<PremoderationProblem> problems;
    }

    @Value
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class PremoderationCategories {
        private static final PremoderationCategories EMPTY = new PremoderationCategories(Collections.emptyList());
        @JsonProperty("list")
        List<TurboPremodCategoryType> list;

        public static PremoderationCategories empty() {
            return EMPTY;
        }
    }

    @Value
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class PremoderationProblem {
        @JsonProperty("comment")
        String comment;
    }

    public enum ModerationStatus {
        @JsonEnumDefaultValue
        @Description("Проверка еще не производилась")
        UNKNOWN,
        @Description("Все хорошо, проверки пройдены.")
        PASS,
        @Description("Тут видимо все терпимо и можны выпускать")
        PROBLEM_PASS,
        @Description("Плохо, и магазин сам должен будет переотрправить не перемодерацию")
        FAILED,
        @Description("Очень плохой магазин, может повторно пройти модерацию только обратившись в поддержку")
        NO_PLACEMENT,
        @Description("Забанен")
        BANNED;

        public boolean isPassed() {
            return this == PASS || this == PROBLEM_PASS;
        }

        public boolean isFailed() {
            return this == FAILED || this == NO_PLACEMENT;
        }
    }

    @Getter
    public enum TurboPremodCategoryType {
        @JsonEnumDefaultValue
        @Description("Неизвестный тип, скорее всего маркет начал выгружать новые типы, которые мы не поддержали")
        UNKNOWN,
        @Description("18+")
        ADULTS_ONLY,
        @Description("Только услуги")
        SERVICE_ONLY,
        @Description("Алкогольная продукция")
        ALCOHOL,
        @Description("Лекарственные средства")
        MEDICINE,
        @Description("БАД")
        DIETARY_SUPPLEMENT,
        @Description("Медицинские изделия")
        MEDICAL_DEVICE,
        @Description("Изделия, конструктивно сходные с оружием")
        SIMILAR_TO_WEAPON,
        @Description("Пиротехника")
        PYROTECHNICS,
        @Description("Результаты интеллектуальной деятельности (объекты авторского и патентного права)")
        COPYRIGHT,
        @Description("Наркотические и психотропные вещества, а также их прекурсоры")
        NARCOTIC,
        @Description("Оптовый магазин")
        WHOLESALE_SHOP,
        @Description("Жучки для прослушивания")
        WIRETAPPING,
        @Description("Средства самообороны")
        MEANS_OF_SELF_DEFENCE,
        @Description("Табачные изделия или курительные аксессуары")
        TOBACCO,
        @Description("Магазин не работает с физ.лицами")
        DOES_NOT_WORK_WITH_INDIVIDUALS,
        @Description("Б/у товары")
        USED_PRODUCTS,
        @Description("Магазин не из России")
        NOT_RUSSIAN,

        @Deprecated
        @Description("Присутствует категория товаров запрещенная на Маркете")
        PROHIBITED_ON_MARKET;
    }
}


