package ru.yandex.webmaster3.storage.turbo.dao.statistics;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.core.turbo.model.statistics.TurboDomainStatistics;
import ru.yandex.webmaster3.core.turbo.model.statistics.TurboHostStatisticsType;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

/**
 * Created by Oleg Bazdyrev on 06/02/2018.
 */
@Repository
public class TurboDomainStatisticsYDao extends AbstractYDao {

    public static final String TABLE_NAME = "turbo_domain_statistics";

    public TurboDomainStatisticsYDao() {
        super(PREFIX_TURBO, TABLE_NAME);
    }

    private static final ValueDataMapper<TurboDomainStatistics> VALUE_DATA_MAPPER = ValueDataMapper.create2(
            Pair.of(F.DOMAIN, TurboDomainStatistics::getDomain),
            Pair.of(F.SOURCE, TurboDomainStatistics::getSource),
            Pair.of(F.UPDATE_DATE, TurboDomainStatistics::getUpdateDate),
            Pair.of(F.FEED, TurboDomainStatistics::getFeed),
            Pair.of(F.TYPE, TurboDomainStatistics::getType),
            Pair.of(F.VALUE, TurboDomainStatistics::getValue)
    );

    public void saveStatistics(Collection<TurboDomainStatistics> statsBatch) {
        batchUpdate(VALUE_DATA_MAPPER, statsBatch).execute();
    }

    public List<TurboDomainStatistics> getStatistics(String owner) {
        return select(MAPPER).where(F.DOMAIN.eq(owner)).queryForList();
    }

    //для автопарсера
    public long getValue(String domain, TurboFeedType source) {
        Long value = select(F.VALUE)
                .where(F.DOMAIN.eq(domain))
                .and(F.SOURCE.eq(source))
                .queryOne();
        return (value == null ? 0 : value);
    }

    public static final DataMapper<TurboDomainStatistics> MAPPER = DataMapper.create(F.DOMAIN, F.SOURCE, F.FEED,
            F.TYPE, F.VALUE, F.UPDATE_DATE, TurboDomainStatistics::new);

    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<TurboFeedType> SOURCE = Fields.intEnumField("source", TurboFeedType.R);
        Field<String> FEED = Fields.stringField("feed");
        Field<TurboHostStatisticsType> TYPE = Fields.intEnumField("type", TurboHostStatisticsType.R);
        Field<Long> VALUE = Fields.longField("value");
        Field<DateTime> UPDATE_DATE = Fields.jodaDateTimeField("update_date");
    }
}
