package ru.yandex.webmaster3.storage.turbo.logo;

import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * Created by ifilippov5 on 31.07.17.
 */
@Component("processTurboLogoService")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ProcessTurboLogoService {
    private final TurboLogoYDao turboLogoYDao;

    public TurboLogoData save(WebmasterHostId hostId, String frontLogoId) {
        Pair<String, Long> pair = TurboLogoData.parseFrontLogoId(frontLogoId);
        TurboLogoData logo = turboLogoYDao.get(hostId, pair.getLeft(), pair.getRight());
        if (logo == null) {
            return null;
        }

        turboLogoYDao.add(logo.markAsUsed());
        return logo;
    }

}
