package ru.yandex.webmaster3.storage.turbo.logo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * Created by ifilippov5 on 25.07.17.
 */
@Value
@Builder(toBuilder = true)
@AllArgsConstructor
public class TurboLogoData {

    public static final String FRONT_LOGO_ID_SEPARATOR = "-";

    WebmasterHostId hostId;
    String logoId;
    long groupId;
    String publicUrl;
    DateTime updateTime;
    boolean used;
    Integer width;
    Integer height;

    // TODO temp for migration
    public static TurboLogoData create(String domain, String logoId, long groupId, String publicUrl, DateTime updateTime, boolean used,
            Integer width, Integer height) {
        return new TurboLogoData(IdUtils.urlToHostId(domain), logoId, groupId, publicUrl, updateTime, used, width, height);
    }

    public static Pair<String, Long> parseFrontLogoId(String frontLogoId) {
        if (frontLogoId == null) {
            return Pair.of("", 0L);
        }
        String[] parts = frontLogoId.split(FRONT_LOGO_ID_SEPARATOR);
        return Pair.of(parts[0], parts.length <= 1 ? 0L : Long.parseLong(parts[1]));
    }

    public TurboLogoData markAsUsed() {
        return toBuilder().used(true).updateTime(DateTime.now()).build();
    }
}
