package ru.yandex.webmaster3.storage.turbo.logo;

import org.apache.commons.lang3.tuple.Triple;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by ifilippov5 on 25.07.17.
 */
@Repository
public class TurboLogoYDao extends AbstractYDao {
    public static final String TABLE_NAME = "turbo_logos";

    public TurboLogoYDao() {
        super(PREFIX_TURBO, TABLE_NAME);
    }

    public void add(TurboLogoData logo) {
        // всегда сохраняем лого для хоста без www и c http
        String domain = WwwUtil.cutWWWAndM(logo.getHostId());
        upsert(F.DOMAIN.value(domain),
                F.LOGO_ID.value(logo.getLogoId()),
                F.GROUP_ID.value(logo.getGroupId()),
                F.PUBLIC_URL.value(logo.getPublicUrl()),
                F.UPDATE_TIME.value(logo.getUpdateTime()),
                F.USED.value(logo.isUsed()),
                F.WIDTH.value(logo.getWidth()),
                F.HEIGHT.value(logo.getHeight())
        ).execute();
    }

    public TurboLogoData get(WebmasterHostId hostId, String logoId, long groupId) {
        String domain = WwwUtil.cutWWWAndM(hostId);
        return select(MAPPER)
                .where(F.DOMAIN.eq(domain))
                .and(F.LOGO_ID.eq(logoId))
                .and(F.GROUP_ID.eq(groupId))
                .queryOne();
    }

    public void delete(WebmasterHostId hostId, String logoId, long groupId) {
        String domain = WwwUtil.cutWWWAndM(hostId);
        delete()
                .where(F.DOMAIN.eq(domain))
                .and(F.LOGO_ID.eq(logoId))
                .and(F.GROUP_ID.eq(groupId))
                .execute();
    }

    public static final DataMapper<TurboLogoData> MAPPER = DataMapper.create(
            F.DOMAIN, F.LOGO_ID, F.GROUP_ID, F.PUBLIC_URL, F.UPDATE_TIME, F.USED, F.WIDTH, F.HEIGHT, TurboLogoData::create
    );

    public static final DataMapper<Triple<String, String, Long>> PK_MAPPER = DataMapper.create(
            F.DOMAIN, F.LOGO_ID, F.GROUP_ID, Triple::of
    );


    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<String> LOGO_ID = Fields.stringField("logo_id");
        Field<Long> GROUP_ID = Fields.longField("group_id");
        Field<String> PUBLIC_URL = Fields.stringField("public_url");
        Field<DateTime> UPDATE_TIME = Fields.jodaDateTimeField("update_time");
        Field<Boolean> USED = Fields.boolField("used");
        Field<Integer> WIDTH = Fields.intField("width").makeOptional();
        Field<Integer> HEIGHT = Fields.intField("height").makeOptional();
    }
}
