package ru.yandex.webmaster3.storage.turbo.service.css;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;
import ru.yandex.webmaster3.core.util.json.polymorphic.Polymorphic;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Oleg Bazdyrev on 21/05/2018.
 */

public enum TurboCssErrorType implements Discriminator<Polymorphic<TurboCssErrorType>> {

    EMPTY_CSS("invalid-request", TurboCssError.EmptyCssError.class),
    CSS_TOO_BIG("compression", TurboCssError.CssTooBigError.class),
    POSTCSS("postcss", TurboCssError.PostCssError.class),
    STYLELINT("stylelint", TurboCssError.StyleLintError.class);

    private static final Map<String, TurboCssErrorType> typesByCode = new HashMap<>();

    static {
        for (TurboCssErrorType type : values()) {
            typesByCode.put(type.getCode(), type);
        }
    }

    private final String code;
    private final Class<? extends TurboCssError> dataClass;

    TurboCssErrorType(String code, Class<? extends TurboCssError> dataClass) {
        this.code = code;
        this.dataClass = dataClass;
    }

    @JsonCreator
    public static TurboCssErrorType fromCode(String code) {
        TurboCssErrorType result = typesByCode.get(code);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum value " + code);
        }
        return result;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getDiscriminatorId() {
        return code;
    }

    @Override
    public Class<? extends Polymorphic<TurboCssErrorType>> getDataClass() {
        return dataClass;
    }
}
