package ru.yandex.webmaster3.storage.turbo.service.css;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 21/05/2018.
 */
public class TurboCssValidatorResponse {

    public static final String STATUS_SUCCESS = "success";
    public static final String STATUS_ERROR = "error";

    private final String status;
    private final String result;
    private final TurboCssError error;

    public TurboCssValidatorResponse(String status, String result, TurboCssError error) {
        this.status = status;
        this.result = result;
        this.error = error;
    }

    public String getStatus() {
        return status;
    }

    public String getResult() {
        return result;
    }

    public boolean isSuccess() {
        return STATUS_SUCCESS.equals(status);
    }

    public TurboCssError getError() {
        return error;
    }

    public List<TurboCssErrorInfo> createErrorInfos() {
        return error == null ? null : error.toInfoList();
    }
}
