package ru.yandex.webmaster3.storage.turbo.service.preview;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.turbo.model.authorization.TurboAuthorizationSettings;

/**
 * Created by Oleg Bazdyrev on 19/03/2019.
 */
public class TurboAuthorizationSettingsData {

    private final String authEndpoint;
    private final String loginEndpoint;
    private final String logoutEndpoint;

    public TurboAuthorizationSettingsData(String authEndpoint, String loginEndpoint, String logoutEndpoint) {
        this.authEndpoint = authEndpoint;
        this.loginEndpoint = loginEndpoint;
        this.logoutEndpoint = logoutEndpoint;
    }

    public static TurboAuthorizationSettingsData fromSettings(TurboAuthorizationSettings settings) {
        if (settings == null) {
            return null;
        }
        return new TurboAuthorizationSettingsData(settings.getAuthEndpoint(),
                settings.getLoginEndpoint(), settings.getLogoutEndpoint());
    }

    @JsonProperty("auth-endpoint")
    public String getAuthEndpoint() {
        return authEndpoint;
    }

    @JsonProperty("login-endpoint")
    public String getLoginEndpoint() {
        return loginEndpoint;
    }

    @JsonProperty("logout-endpoint")
    public String getLogoutEndpoint() {
        return logoutEndpoint;
    }
}
