package ru.yandex.webmaster3.storage.turbo.service.preview;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.turbo.model.TurboAutoRelatedSettings;

public class TurboAutoRelatedSettingsData {
    private final String type;

    public TurboAutoRelatedSettingsData(String type) {
        this.type = type;
    }

    public static TurboAutoRelatedSettingsData fromSettings(TurboAutoRelatedSettings settings) {
        if (settings == null || settings.getType() == null) {
            return null;
        }
        return new TurboAutoRelatedSettingsData(settings.getType().getDisplayName());
    }

    @JsonProperty("type")
    public String getType() {
        return type;
    }
}
