package ru.yandex.webmaster3.storage.turbo.service.preview;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.turbo.model.comments.TurboCommentsSettings;

/**
 * Created by Oleg Bazdyrev on 19/03/2019.
 * WMC-7070
 */
public class TurboCommentsSettingsData {

    private final String getCommentsEndpoint;
    private final String addCommentsEndpoint;
    private final boolean yandexComments;

    public TurboCommentsSettingsData(String getCommentsEndpoint,
                                     String addCommentsEndpoint, boolean yandexComments) {
        this.getCommentsEndpoint = getCommentsEndpoint;
        this.addCommentsEndpoint = addCommentsEndpoint;
        this.yandexComments = yandexComments;
    }

    public static TurboCommentsSettingsData fromSettings(TurboCommentsSettings settings) {
        if (settings == null) {
            return null;
        }
        boolean yandexComments = settings.getStatus() == TurboCommentsSettings.TURBO_COMMENT_STATUS.CMNT;
        return new TurboCommentsSettingsData(settings.getGetCommentsEndpoint(), settings.getAddCommentsEndpoint(), yandexComments);
    }

    @JsonProperty("get-comments-endpoint")
    public String getGetCommentsEndpoint() {
        return getCommentsEndpoint;
    }

    @JsonProperty("add-comments-endpoint")
    public String getAddCommentsEndpoint() {
        return addCommentsEndpoint;
    }

    @JsonProperty("use-yandex-commentator")
    public boolean getYandexComments() {
        return yandexComments;
    }

}
