package ru.yandex.webmaster3.storage.turbo.service.preview;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.app.TurboAppSettings;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettings;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedSettings;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.turbo.service.TurboDomainsStateService.TurboDomainState;

/**
 * Created by Oleg Bazdyrev on 10/10/2017.
 */
public class TurboFeedPreviewRequest {

    private final String host;
    private final String url;
    private final TurboFeedType type;
    private final TurboHostSettingsData hostData;

    public TurboFeedPreviewRequest(WebmasterHostId hostId, String url, TurboFeedType type,
                                   TurboHostSettings hostSettings, TurboDesktopSettings desktopSettings, TurboAppSettings appSettings,
                                   TurboDomainState domainState, List<TurboFeedSettings> feeds) {
        this.host = IdUtils.hostIdToUrl(hostId);
        this.url = url;
        this.type = type;
        this.hostData = hostSettings == null ? null :
                new TurboHostSettingsData(hostSettings, desktopSettings, appSettings, type == TurboFeedType.YML, domainState, feeds);
    }

    public String getHost() {
        return host;
    }

    public String getUrl() {
        return url;
    }

    @JsonProperty("format")
    public TurboFeedType getType() {
        return type;
    }

    @JsonProperty("host_data")
    public TurboHostSettingsData getHostData() {
        return hostData;
    }

}
