package ru.yandex.webmaster3.storage.turbo.service.preview;

import java.util.List;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.app.TurboAppSettings;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettings;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedSettings;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.turbo.service.TurboDomainsStateService.TurboDomainState;

/**
 * Created by Oleg Bazdyrev on 10/10/2017.
 */
public class TurboHostSettingsUploadRequest {

    private final String host;
    private final TurboHostSettingsData data;

    public TurboHostSettingsUploadRequest(WebmasterHostId hostId, TurboHostSettings settings, TurboDesktopSettings desktopSettings,
                                          TurboAppSettings appSettings, boolean yml, TurboDomainState domainState,
                                          List<TurboFeedSettings> feeds) {
        this.host = IdUtils.hostIdToUrl(hostId);
        this.data = new TurboHostSettingsData(settings, desktopSettings, appSettings, yml, domainState, feeds);
    }

    public String getHost() {
        return host;
    }

    public TurboHostSettingsData getData() {
        return data;
    }
}
