package ru.yandex.webmaster3.storage.turbo.service.preview;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ru.yandex.webmaster3.core.turbo.model.error.TurboRawError;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;


/**
 * Created by Oleg Bazdyrev on 04/09/2018.
 * Ответ от ручки первью /host_data
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class TurboHostSettingsUploadResponse {

    private final Errors errors;
    private final List<SavedDocument> savedDocuments;

    @JsonCreator
    public TurboHostSettingsUploadResponse(
            @JsonProperty("errors") Errors errors,
            @JsonProperty("saved_docs") List<SavedDocument> savedDocuments) {
        this.errors = errors;
        this.savedDocuments = savedDocuments == null ? Collections.emptyList() : savedDocuments;
    }

    @JsonProperty("errors")
    public Errors getErrors() {
        return errors;
    }

    @JsonProperty("saved_docs")
    public List<SavedDocument> getSavedDocuments() {
        return savedDocuments;
    }

    public static final class SavedDocument {

        private final List<SavedDocumentData> data;

        @JsonCreator
        public SavedDocument(@JsonProperty("data") List<SavedDocumentData> data) {
            this.data = data == null ? Collections.emptyList() : data;
        }

        public List<SavedDocumentData> getData() {
            return data;
        }
    }

    public static final class SavedDocumentData {

        private final SavedProductInfo productInfo;

        @JsonCreator
        public SavedDocumentData(@JsonProperty("product_info") SavedProductInfo productInfo) {
            this.productInfo = productInfo;
        }

        @JsonProperty("product_info")
        public SavedProductInfo getProductInfo() {
            return productInfo;
        }

    }

    public static final class SavedProductInfo {

        private final JsonNode accordion;

        @JsonCreator
        public SavedProductInfo(@JsonProperty("accordion") JsonNode accordion) {
            this.accordion = accordion;
        }

        public JsonNode getAccordion() {
            return accordion;
        }
    }

    public static final class Errors {

        private final ErrorProductInfo productInfo;

        @JsonCreator
        public Errors(@JsonProperty("product_info") ErrorProductInfo productInfo) {
            this.productInfo = productInfo;
        }

        @JsonProperty("product_info")
        public ErrorProductInfo getProductInfo() {
            return productInfo;
        }
    }

    public static final class ErrorProductInfo {

        private final Map<String, List<ObjectNode>> accordion;

        @JsonCreator
        public ErrorProductInfo(@JsonProperty("accordion") Map<String, List<ObjectNode>> accordion) {
            this.accordion = accordion;
        }

        public Map<String, List<ObjectNode>> getAccordion() {
            return accordion;
        }
    }

    public List<TurboRawError> collectTurboRawErrors() {
        List<TurboRawError> rawErrors = new ArrayList<>();
        if (errors == null || errors.getProductInfo() == null || errors.getProductInfo().getAccordion() == null) {
            return rawErrors;
        }
        errors.getProductInfo().getAccordion().forEach((sectionNumber, errorNodes) -> {
            for (ObjectNode errorNode : errorNodes) {
                TurboRawError rawError = TurboRawError.fromObjectNode(errorNode, sectionNumber);
                rawErrors.add(rawError);
            }
        });
        rawErrors.sort(TurboRawError.BY_CODE_AND_LINE);
        return rawErrors;
    }
}
